using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hiveAdiz
{
	public class AdizRewarded
	{

		private static AdizRewarded instance = null;
		private AdizRewarded() {}

		~AdizRewarded() {
			//
		}

		private string adKey = "";

		public static AdizRewarded Initialize(AdEventHandlers handler) {

			string defaultKey = AdizCallbackManager.defaultRewardedKey;
			if(string.IsNullOrEmpty(defaultKey)) { 
				AdizLogger.d("adKey is null or empty.");
				return null; 
			}

			instance = new AdizRewarded();
			instance.internalInit(defaultKey, handler);
			return instance;
		}

		public static AdizRewarded Initialize(string hiveAdKey, AdEventHandlers handler) {

			if(string.IsNullOrEmpty(hiveAdKey)) { 
				AdizLogger.d("adKey is null or empty.");
				return null; 
			}

			instance = new AdizRewarded();
			instance.internalInit(hiveAdKey, handler);
			return instance;
		}

		public static AdizRewarded InitializeWithPlacementId(string placementId, AdEventHandlers handler) {

			if(string.IsNullOrEmpty(placementId)) { 
				AdizLogger.d("placementId is null or empty.");
				return null; 
			}

			string hiveAdKey = AdizUnityNativeCaller.Instance.GetHiveAdKeyFromPlacementId(placementId);
			if(string.IsNullOrEmpty(hiveAdKey)) { 
				AdizLogger.d("placementId is invalid");
				return null; 
			}

			instance = new AdizRewarded();
			instance.internalInit(hiveAdKey, handler);
			return instance;
		}

		private void release() {
			if(AdizCallbackManager.callbackHandler.ContainsKey(adKey)) {
				AdizCallbackManager.callbackHandler.Remove(adKey);	
			}

			instance = null;
		}

	#if UNITY_ANDROID && !UNITY_EDITOR
		
		private AndroidJavaObject currentActivity = null;
		private AndroidJavaObject hiveAdizPlugin = null;

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			AdizLogger.d("AdizRewarded Init "+hiveAdKey);

			AndroidJavaClass jc = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			currentActivity = jc.GetStatic<AndroidJavaObject>("currentActivity");
			hiveAdizPlugin = new AndroidJavaObject("com.hive.adiz.plugin.AdizUnityRewarded");

			adKey = hiveAdKey;
			hiveAdizPlugin.Call("initialize", currentActivity, hiveAdKey);
			
			if(AdizCallbackManager.callbackHandler.ContainsKey(hiveAdKey)) {
				AdizCallbackManager.callbackHandler.Remove(hiveAdKey);	
			}
			AdizCallbackManager.callbackHandler.Add(hiveAdKey, handler);
		}

		public void Load() {
			AdizLogger.d("AdizRewarded Load");
			hiveAdizPlugin.Call("load");
		}

		public void Show() {
			AdizLogger.d("AdizRewarded Show");
			hiveAdizPlugin.Call("show");
		}

		public void Destroy() {
			hiveAdizPlugin.Call("destroy");
			release();
		}

		public bool IsInitialized() {
			return hiveAdizPlugin.Call<bool>("isInitialized");
		}

		public bool IsLoaded() {
			return hiveAdizPlugin.Call<bool>("isLoaded");
		}

	#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void Adiz_RewardedInitialize(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_RewardedLoad(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_RewardedShow(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_RewardedDestroy(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern bool Adiz_RewardedIsInitialized(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern bool Adiz_RewardedIsLoaded(string hiveAdKey);

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			AdizLogger.d("AdizRewarded Init "+hiveAdKey);
			adKey = hiveAdKey;
			
			if(AdizCallbackManager.callbackHandler.ContainsKey(hiveAdKey)) {
				AdizCallbackManager.callbackHandler.Remove(hiveAdKey);	
			}
			AdizCallbackManager.callbackHandler.Add(hiveAdKey, handler);

			Adiz_RewardedInitialize(hiveAdKey);
		}

		public void Load() {
			AdizLogger.d("AdizRewarded Load");
			Adiz_RewardedLoad(adKey);
		}

		public void Show() {
			AdizLogger.d("AdizRewarded Show");
			Adiz_RewardedShow(adKey);
		}

		public void Destroy() {
			AdizLogger.d("AdizRewarded Destroy");
			Adiz_RewardedDestroy(adKey);
			release();
		}

		public bool IsInitialized() {
			return Adiz_RewardedIsInitialized(adKey);
		}

		public bool IsLoaded() {
			return Adiz_RewardedIsLoaded(adKey);
		}
	#else

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			
		}

		public void Load() {
			
		}			

		public void Show() {
			
		}

		public void Destroy() {
			
		}
		
		public bool IsInitialized() {
			return false;
		}

		public bool IsLoaded() {
			return false;
		}
	#endif
		
	}
}